<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductModel extends Model
{
    use HasFactory;
    protected $table = 'products';
    protected $fillable = [
        'name',
        'native_name',
        'code',
        'hsn_code',
        'category_id',
        'supplier_id',
        'unit_price',
        'margin_price',
        'description',
        'products_image',
        'branch_id',
        'qty',
        // 'margin_price',
        'status',
        'total_amount',
        'total_qty',
        'product_type',
        'assembled_item_id',
    ];
    public function category()
    {
        return $this->belongsTo(CategoryModel::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function productHistory()
    {
        return $this->belongsTo(ProductHistoryModel::class);
    }
    public function details()
    {
        return $this->hasMany(ProductDetailsModel::class, 'product_id');
    }

    public function supplier()
    {
        return $this->belongsTo(SupplierModel::class, 'supplier_id');
    }

    public function ProductType()
    {
        return $this->belongsTo(ProductTypeModel::class, 'product_type');
    }

    public function assembledItem()
    {
        return $this->belongsTo(AssembledItemModel::class, 'assembled_item_id');
    }

    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
}
