@extends('layouts.layoutapp')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-body">
                    <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                        <form method="GET" action="{{ route('emi_profit_report') }}" class="d-flex align-items-center">

                            <div class="form-group me-3">
                                <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                    id="start_date" name="start_date"
                                    value="{{ old('start_date', request()->get('start_date')) }}">

                                <!-- Display error message for start_date -->
                                @error('start_date')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="form-group me-3">
                                <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                    id="end_date" name="end_date" value="{{ old('end_date', request()->get('end_date')) }}">

                                <!-- Display error message for end_date -->
                                @error('end_date')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </form>
                    </div>
                    <div class="mb-4">
                        <div class="table-responsive">
                            <table class="table text-center text-sm" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Invoice Id</th>
                                        <th>Invoice Date</th>
                                        <th>Total Selling Price</th>
                                        <th>Total Buying Price</th>
                                        <th>Curent Profit</th>
                                        <th>Total Profit</th>
                                        <th>Tax Amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($profitDetails as $index => $detail)
                                        <tr>
                                            <td>{{$detail['invoice_id']}}</td>
                                            <td>{{\Carbon\Carbon::parse($detail['invoice_date'])->format('d-m-Y')}}</td>
                                            <td>₹ {{ number_format($detail['total_selling_price'], 2) }}</td>
                                            <td>₹ {{ number_format($detail['total_margin_price'], 2) }}</td>
                                            <td>₹ {{ number_format($detail['current_profit'], 2) }}</td>
                                            <td>₹ {{ number_format($detail['total_profit'], 2) }}</td>
                                            <td>₹ {{ number_format($detail['tax_amount'], 2) }}</td>
                                            <td>
                                                <!-- Button to trigger modal -->
                                                <button data-bs-toggle="modal" data-bs-target="#productDetailsModal{{ $index }}"
                                                    style="border:none;background:none">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Product Details Modals -->
                        @foreach ($profitDetails as $index => $detail)
                            <div class="modal fade" id="productDetailsModal{{ $index }}" tabindex="-1"
                                aria-labelledby="productDetailsModalLabel{{ $index }}" aria-hidden="true">
                                <div class="modal-dialog modal-xl">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="productDetailsModalLabel{{ $index }}">Invoice EMI
                                                Profit
                                                Details: {{ $detail['invoice_id'] }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body table-responsive">
                                            <table class="table table-bordered text-center text-sm">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">EMI Date</th>
                                                        <th class="text-center">EMI Amount</th>
                                                        <th class="text-center">Paid Date</th>
                                                        <th class="text-center">Due Days</th>
                                                        <th class="text-center">Penalty Amount</th>
                                                        <th class="text-center">Discount Amount</th>
                                                        <th class="text-center">Paid Amount</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($detail['emi_profit_details'] as $product)
                                                        <tr>
                                                            <td>{{ $product['emi_date'] }}</td>
                                                            <td>₹{{ $product['emi_amount'] }}</td>
                                                            <td>{{ $product['paid_date'] }}</td>
                                                            <td>{{ $product['due_date'] ?? 0}} </td>
                                                            <td>₹{{ $product['penalty'] ?? 0  }}</td>
                                                            <td>₹{{ $product['discount_amount'] ?? 0}}</td>
                                                            <td>₹{{ $product['total_amount'] ?? 0 }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection