

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <form action="<?php echo e(route('product-update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Edit Product</h5>
                            </div>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">Update Product</button>
                                <a href="<?php echo e(route('product-index')); ?>" class="btn btn-secondary btn-sm">Cancel</a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        <div class="row">
                            <!-- Left Column -->
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="name" class="form-label">Name:</label>
                                        <input type="text" id="name" name="name" class="form-control"
                                            value="<?php echo e(old('name', $product->name)); ?>" placeholder="Enter product name"
                                            required>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="native_name" class="form-label">Native Name:</label>
                                        <input type="text" id="native_name" name="native_name" class="form-control"
                                            value="<?php echo e(old('native_name', $product->native_name)); ?>"
                                            placeholder="Enter native name" required>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="margin_price" class="form-label">Buying Price / Unit:</label>
                                        <input type="number" id="margin_price" name="margin_price" class="form-control"
                                            value="<?php echo e(old('margin_price', $product->margin_price)); ?>" placeholder="0.00"
                                            min="0" step="0.01" required>
                                        <?php $__errorArgs = ['margin_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="unit_price" class="form-label">Selling Price / Unit:</label>
                                        <input type="number" id="unit_price" name="unit_price" class="form-control"
                                            value="<?php echo e(old('unit_price', $product->unit_price)); ?>" placeholder="0.00" min="0"
                                            step="0.01" required>
                                        <?php $__errorArgs = ['unit_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="supplier_id" class="form-label">Supplier:</label>
                                        <select name="supplier_id" class="form-select" required>
                                            <option value="" disabled>Select Supplier</option>
                                            <option value="" <?php echo e(empty(old('supplier_id', $product->supplier_id)) ? 'selected' : ''); ?>>Internal</option>
                                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($supplier->id); ?>" <?php echo e(old('supplier_id', $product->supplier_id) == $supplier->id ? 'selected' : ''); ?>>
                                                    <?php echo e($supplier->supplier_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="description" class="form-label">Description:</label>
                                        <textarea id="description" name="description" class="form-control" rows="1"
                                            placeholder="Enter product description (optional)"><?php echo e(old('description', $product->description)); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column -->
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="productCode" class="form-label">Product Code:</label>
                                        <input type="text" id="productCode" name="productCode" class="form-control"
                                            value="<?php echo e(old('productCode', $product->code)); ?>"
                                            placeholder="Enter product code" required>
                                        <?php $__errorArgs = ['productCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="hsnCode" class="form-label">HSN Code:</label>
                                        <input type="text" id="hsnCode" name="hsnCode" class="form-control"
                                            value="<?php echo e(old('hsnCode', $product->hsn_code)); ?>" placeholder="Enter HSN code">
                                        <?php $__errorArgs = ['hsnCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="qty" class="form-label">Quantity:</label>
                                        <input type="number" id="qty" name="qty" class="form-control"
                                            value="<?php echo e(old('qty', $product->qty)); ?>" readonly placeholder="0" min="0"
                                            step="0.01" required>
                                        <?php $__errorArgs = ['qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="category_id" class="form-label">Category:</label>
                                        <select name="category_id" class="form-select" required>
                                            <option value="" selected disabled>Select Category</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e((old('category_id', $product->category_id) == $category->id) ? 'selected' : ''); ?>>
                                                    <?php echo e($category->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="product_image" class="form-label">Upload Image:</label>
                                        <div class="avatar-edit">
                                            <input type="file" id="product_image" name="product_image"
                                                class="form-control file-upload-input" accept="image/*"
                                                onchange="previewImage(this)">
                                            <small class="text-muted">Upload new image (max 2MB)</small>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-preview">
                                                <img id="imagePreview"
                                                    src="<?php echo e($product->products_image ? getFileUrl($product->products_image) : asset('assets/img/logos/Product.png')); ?>"
                                                    alt="Product Image" class="img-fluid"
                                                    style="width: 80px; height: 80px; object-fit: cover;">
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['product_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Product Details Table -->
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th class="text-center text-xs">#</th>
                                <th class="text-center text-xs">Action</th>
                                <th class="text-center text-xs">Product Details ID</th>
                                <th class="text-center text-xs">Supplier</th>
                                <th class="text-center text-xs">Selling Price</th>
                                <th class="text-center text-xs">Buying Price</th>
                                <th class="text-center text-xs">Updated Qty</th>
                                <th class="text-center text-xs">Total Amount</th>
                                <th class="text-center text-xs">Payment Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $product->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center text-xs"><?php echo e($index + 1); ?></td>
                                    <td class="text-center text-xs">
                                        <?php if(empty($data->assembled_item_id)): ?>
                                            <a href="javascript:void(0)" class="edit-details" id="edit_details"
                                                data-bs-toggle="modal" data-bs-target="#productDetails" data-details='<?php echo json_encode($data, 15, 512) ?>'>
                                                <i class="fa-solid fa-pen-to-square ms-2" data-bs-toggle="tooltip"
                                                    data-bs-placement="top" title="Edit Details"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a href="javascript:void(0)" class="view-refund" data-bs-toggle="modal"
                                            data-bs-target="#productRefundDetails" data-details='<?php echo json_encode($data, 15, 512) ?>'>
                                            <i class="fa-solid fa-rotate-left ms-2" data-bs-toggle="tooltip"
                                                data-bs-placement="top" title="View Refund Details"></i>
                                        </a>
                                    </td>

                                    <td class="text-center text-xs"><?php echo e($data->product_details_code ?? ''); ?></td>
                                    <td class="text-center text-xs">
                                        <?php echo e(isset($data->suppliers) ? $data->suppliers->supplier_name : 'Internal'); ?>

                                    </td>
                                    <td class="text-center text-xs"><?php echo e(number_format($data->unit_price ?? '', 2)); ?></td>
                                    <td class="text-center text-xs"><?php echo e(number_format($data->margin_price ?? '', 2)); ?></td>
                                    <td class="text-center text-xs"><?php echo e($data->qty ?? ''); ?></td>
                                    <td class="text-center text-xs"><?php echo e($data->total_amount ?? ''); ?></td>
                                    <td class="text-center text-xs">
                                        <?php if($data->paymentStatus->name == 'Paid'): ?>
                                            <span class="badge bg-success">Paid</span>
                                        <?php elseif($data->paymentStatus->name == 'Partially Paid'): ?>
                                            <span class="badge bg-warning">Partially Paid</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Unpaid</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-center" colspan="8"> No Details Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Product Details Modal -->
    <div class="modal fade" id="productDetails" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Product Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form class="product-details-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" class="detail_id" name="detail_id" value="">
                        <input type="hidden" class="detail_code" name="detail_code" value="">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Supplier Name & Number</label>
                                <input type="text" id="supplier_dtls" name="supplier_dtls" class="form-control"
                                    value="<?php echo e(old('supplier_dtls')); ?>" placeholder="Enter Supplier Details" readonly
                                    required>
                                <?php $__errorArgs = ['supplier_dtls'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">Reason:</label>
                                <select name="status" class="form-select" required>
                                    <option value="" selected disabled>Select Reason</option>
                                    <option value="update">Update Quantity</option>
                                    <option value="refund">Return to Supplier</option>
                                    <option value="non_returnable">Non-Returnable (Damaged)</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Purchased Quantity:</label>
                                <input type="number" id="purchased_qty" name="purchased_qty" class="form-control"
                                    value="<?php echo e(old('purchased_qty')); ?>" min="1" placeholder="Enter purchased quantity"
                                    required>
                                <?php $__errorArgs = ['purchased_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th class="text-center">Product Qty</th>
                                        <th class="text-center">Buying Price</th>
                                        <th class="text-center">Paid Amount</th>
                                        <th class="text-center">Updated Qty</th>
                                        <th class="text-center">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center product_qty"></td>
                                        <td class="text-center margin_price"></td>
                                        <td class="text-center paid_amount"></td>
                                        <td class="text-center updated_qty"></td>
                                        <td class="text-center"> <input type="text" name="amount"
                                                class="form-control amount" id="amount" placeholder="Enter amount" readonly>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary details-save">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Refund Details Modal -->
    <div class="modal fade" id="productRefundDetails" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Refund Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="product-name"></h4>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center text-xs">Refund Date</th>
                                    <th class="text-center text-xs">Amount</th>
                                    <th class="text-center text-xs">Payment Method</th>
                                </tr>
                            </thead>
                            <tbody class="refund-table-body">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            initTooltips();
            setupEventHandlers();
        });

        function initTooltips() {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));

            tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                const tooltip = new bootstrap.Tooltip(tooltipTriggerEl, {
                    trigger: 'hover focus',
                    placement: 'top',
                    delay: { show: 100, hide: 50 }
                });

                tooltipTriggerEl.addEventListener('mouseleave', function () {
                    tooltip.hide();
                });
            });

            document.body.addEventListener('mouseover', function (e) {
                const target = e.target.closest('[data-bs-toggle="tooltip"]');
                if (target && !target._tooltip) {
                    const tooltip = new bootstrap.Tooltip(target, {
                        trigger: 'hover focus',
                        placement: 'top'
                    });
                    target._tooltip = tooltip;

                    target.addEventListener('mouseleave', function () {
                        tooltip.hide();
                    });
                }
            });
        }

        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('imagePreview').src = e.target.result;
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        function setupEventHandlers() {
            document.querySelectorAll('.edit-details').forEach(button => {
                button.addEventListener('click', function (e) {
                    const data = JSON.parse(this.getAttribute('data-details'));
                    populateEditModal(data);
                });
            });

            document.querySelectorAll('.view-refund').forEach(button => {
                button.addEventListener('click', function (e) {
                    const data = JSON.parse(this.getAttribute('data-details'));
                    populateRefundModal(data);
                });
            });

            document.querySelector('.details-save')?.addEventListener('click', saveProductDetails);
        }
        function populateEditModal(details) {
            document.querySelector('.detail_id').value = details.product_details_sid;
            document.querySelector('.detail_code').value = details.product_details_code;
            document.querySelector('#purchased_qty').value = details.qty;
            document.querySelector('#supplier_dtls').value =
                `${details.suppliers?.supplier_name || ''} - ${details.suppliers?.phone || ''}`;

            // Store original values for comparison
            document.querySelector('#purchased_qty').dataset.originalQty = details.qty;
            document.querySelector('.product_qty').textContent = details.qty ?? '';
            document.querySelector('.margin_price').textContent = details.margin_price ?? '';

            let totalPaid = 0;
            let refund = 0;
            let loss = 0;

            details.payments.forEach(payment => {
                if (payment.type === 'paid') {
                    totalPaid += parseFloat(payment.paid_amount ?? 0);
                } else if (payment.type === 'refund') {
                    refund += parseFloat(payment.paid_amount ?? 0);
                } else if (payment.type === 'loss') {
                    loss += parseFloat(payment.paid_amount ?? 0);
                }
            });

            const netPaidAmount = totalPaid - refund - loss;
            document.querySelector('.paid_amount').textContent = netPaidAmount.toFixed(2);
            document.querySelector('.updated_qty').textContent = '';
            document.querySelector('.amount').value = '';

            const quantityInput = document.querySelector('#purchased_qty');
            const reasonSelect = document.querySelector('select[name="status"]');
            const amountInput = document.querySelector('.amount');
            const marginPrice = parseFloat(details.margin_price) || 0;

            function updateFields() {
                const originalQty = parseFloat(quantityInput.dataset.originalQty) || 0;
                const newQty = parseFloat(quantityInput.value) || 0;
                const difference = newQty - originalQty;
                const selectedReason = reasonSelect.value;

                // Update quantity difference display
                const updatedQtyCell = document.querySelector('.updated_qty');
                if (difference !== 0) {
                    const sign = difference > 0 ? '+' : '-';
                    const color = difference > 0 ? 'text-success' : 'text-danger';
                    updatedQtyCell.innerHTML = `<span class="${color}">${sign}${Math.abs(difference)}</span>`;
                } else {
                    updatedQtyCell.textContent = '';
                }

                // Reset amount field
                amountInput.value = '';
                const qtyChange = Math.abs(difference);
                const calculatedAmount = qtyChange * marginPrice;

                if (selectedReason === 'update' && difference > 0) {
                    // For quantity increase
                    amountInput.value = calculatedAmount.toFixed(2);
                } else if (selectedReason === 'refund' && difference < 0) {
                    // Refund logic for reduced quantity
                    const returnedQty = originalQty - newQty;

                    const paidQty = netPaidAmount / marginPrice;
                    const unpaidQty = originalQty - paidQty;

                    if (returnedQty > unpaidQty) {
                        const refundableQty = returnedQty - unpaidQty;
                        const refundAmount = refundableQty * marginPrice;

                        if (refundAmount > 0) {
                            amountInput.value = refundAmount.toFixed(2);
                        }
                    }
                } else if (selectedReason === 'non_returnable' && difference < 0) {
                    // Show full lost margin amount
                    amountInput.value = calculatedAmount.toFixed(2);
                }
            }

            quantityInput.addEventListener('input', updateFields);
            reasonSelect.addEventListener('change', updateFields);
        }



        function populateRefundModal(data) {
            const refundTableBody = document.querySelector('.refund-table-body');
            const modalProductName = document.querySelector('.product-name');

            refundTableBody.innerHTML = '';
            modalProductName.textContent = data.name || '';

            if (data.payments && Array.isArray(data.payments)) {
                const refundPayments = data.payments.filter(payment => payment.type === 'refund');

                if (refundPayments.length > 0) {
                    let totalAmount = 0;

                    refundPayments.forEach(payment => {
                        const amount = parseFloat(payment.paid_amount) || 0;
                        totalAmount += amount;

                        const row = `
                                                                                                                                                                                                <tr>
                                                                                                                                                                                                    <td class="text-center text-xs">${payment.payment_date || ''}</td>
                                                                                                                                                                                                    <td class="text-center text-xs">${amount.toFixed(2)}</td>
                                                                                                                                                                                                    <td class="text-center text-xs">${payment.payment_type || ''}</td>
                                                                                                                                                                                                </tr>
                                                                                                                                                                                            `;
                        refundTableBody.insertAdjacentHTML('beforeend', row);
                    });

                    // Add total row
                    const totalRow = `
                                                                                                                                                                                            <tr class="fw-bold">
                                                                                                                                                                                                <td class="text-end text-xs" colspan="1">Total</td>
                                                                                                                                                                                                <td class="text-center text-xs">${totalAmount.toFixed(2)}</td>
                                                                                                                                                                                                <td></td>
                                                                                                                                                                                            </tr>
                                                                                                                                                                                        `;
                    refundTableBody.insertAdjacentHTML('beforeend', totalRow);
                } else {
                    refundTableBody.innerHTML = `
                                                                                                                                                                                            <tr>
                                                                                                                                                                                                <td colspan="3" class="text-center text-xs">No Refunds Found</td>
                                                                                                                                                                                            </tr>
                                                                                                                                                                                        `;
                }
            } else {
                refundTableBody.innerHTML = `
                                                                                                                                                                                        <tr>
                                                                                                                                                                                            <td colspan="3" class="text-center text-xs">No Refunds Found</td>
                                                                                                                                                                                        </tr>
                                                                                                                                                                                    `;
            }
        }

        function saveProductDetails() {
            const detailsForm = document.querySelector('.product-details-form');

            if (detailsForm.checkValidity()) {
                const formData = new FormData(detailsForm);

                fetch('<?php echo e(route('product-details-update')); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire({
                                title: 'Success!',
                                text: data.message || 'Product details updated successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data.message || 'An error occurred while updating the product details.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire({
                            title: 'Error!',
                            text: 'An error occurred while updating the product details.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    });
            } else {
                detailsForm.reportValidity();
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/products/edit.blade.php ENDPATH**/ ?>