

<?php $__env->startSection('content'); ?>
        <div class="row">
        <div class="col-12">
            <div class="card me-2">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Clients</h5>
                            </div>
                            <div>
                                <a href="<?php echo e(route('client-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                    Client</a>
                                    <a href="<?php echo e(route('client-import-index')); ?>" class="btn bg-gradient-primary btn-sm mb-0"> Bulk
                                        Import</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">
                        
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">ID
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Name</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Number</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Email</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Company Name</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($loop->iteration); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($client->user->name ?? ''); ?>

                                                    <?php echo e($client->user->last_name ?? ''); ?>

                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($client->user->phone ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($client->user->email ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($client->company_name ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($client->active_status == "A" ? "Active" : "Inactive"); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('client-edit', ['id'=>$client->id])); ?>" >
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <span class="ms-2">
                                                <form action="<?php echo e(route('client-delete', $client->id)); ?>" method="POST"
                                                    class="d-inline" id="delete-form-<?php echo e($client->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>                                                   
                                                        <i class="cursor-pointer fas fa-trash text-secondary" onclick="confirmDelete(<?php echo e($client->id); ?>)"></i>                                                
                                                </form>
                                            </span>
                                            </td>
                                        </tr>                                   
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            function confirmDelete(clientId) {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + clientId).submit();
                    }
                });
            }
        </script>

    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/clients/index.blade.php ENDPATH**/ ?>