@extends('layouts.layoutapp')
@section('content')

<div class="main-container">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="mb-0">Invoice EMI</h4>     
            <div>
                <button class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#preClosureModal" id="preClosureBtn">Pre-closure</button>
                <button class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#paymentModal" id="paymentBtn">Pay</button>
                <a href="{{ route('invoice-emi-index') }}" class="btn btn-light">Cancel</a> 
            </div>                
        </div> 
        <div class="row p-3">
            <div class="col-md-3 mb-3">
                <label for="invoice_id" class="form-label">Invoice number:</label>
                <input type="text" id="invoice_id" class="form-control" value="{{ $invoice->invoice_id }}" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label for="client_name" class="form-label">Client Name:</label>
                <input type="text" value="{{ $invoice->client->user->name }}" class="form-control" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label for="mobile_number" class="form-label">Mobile Number:</label>
                <input type="number" value="{{ $invoice->client->user->phone }}" class="form-control" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label for="loan_amount" class="form-label">Loan Amount:</label>
                <input type="number" value="{{ $invoice->final_amount }}" class="form-control" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label for="down_payment" class="form-label">Down Payment:</label>
                <input type="number" value="{{ $invoice->invoice_emi->down_payment }}" class="form-control" readonly>
            </div>  
            <div class="col-md-3 mb-3">
                <label for="interest_rate" class="form-label">Interest Rate(%):</label>
                <input type="number" value="{{ $invoice->invoice_emi->intersest_rate }}" class="form-control" readonly>
            </div>         
            <div class="col-md-3 mb-3">
                <label for="actual_amount" class="form-label">Actual Amount(With Interest):</label>
                <input type="number" value="{{ $invoice->invoice_emi->actual_amount }}" class="form-control" readonly>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table borderd">
                <thead>
                    <tr>
                        <th class="text-center"><input type="checkbox" name="select" id="select_all" /></th>
                        <th class="text-center">EMI Date</th>
                        <th class="text-center">EMI Amount</th>
                        <th class="text-center">Paid Date</th>
                        <th class="text-center">Paid Amount</th>
                        <th class="text-center">Due Days</th>
                        <th class="text-center">Penalty</th>
                        <th class="text-center">Discount</th>
                        <th class="text-center">Total Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($invoice_dtls as $item)   
                    @php                   
                    $class = ($item->oprntl_flag == 'P' || $item->oprntl_flag == 'C') ? '#e9ecef' : ''; 
                    $emiDate = \Carbon\Carbon::parse($item->emi_date);
                    $daysPast = 0;
                    if (is_null($item->paid_date)) {
                        $daysPast = $emiDate->isPast() ? $emiDate->diffInDays(now()) : 0;
                    } else {
                        $paidDate = \Carbon\Carbon::parse($item->paid_date);
                        $daysPast = $emiDate->diffInDays($paidDate, false);        
                    }
                    $penalty_amount = (int)$daysPast * $invoice->invoice_emi->penalty_amount;
                    @endphp             
                    <tr data-emi-id="{{ $item->id }}"
                        data-emi-date="{{ $item->emi_date ? \Carbon\Carbon::parse($item->emi_date)->format('d/m/Y') : '' }}"
                        data-emi-amount="{{ round($item->emi_amount ?? '', 2) }}"
                        data-due-days="{{ max((int)$daysPast ?? '', 0) }}"
                        data-penalty="{{ max(round($item->penalty ?? $penalty_amount, 2), 0) }}"
                        data-discount="{{ $item->discount_amount ?? 0 }}"
                        data-total="{{ $item->total_amount ?? round($item->emi_amount ?? 0, 2) + max(round($item->penalty ?? $penalty_amount, 2), 0) - ($item->discount_amount ?? 0) }}">                       
                        <td class="text-center" style="background-color:{{$class}}">
                            <input type="checkbox" class="select-item" value="{{ $item->id }}" name="selected_invoices[]" 
                                   {{ ($item->oprntl_flag == 'P' || $item->oprntl_flag == 'C') ? 'disabled' : '' }}/>
                        </td>
                        <td class="text-center" style="background-color:{{$class}}">{{ $item->emi_date ? \Carbon\Carbon::parse($item->emi_date)->format('d/m/Y') : '' }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ round($item->emi_amount ?? '', 2) }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ $item->paid_date ? \Carbon\Carbon::parse($item->paid_date)->format('d/m/Y') : '' }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ $item->paid_amount ?? '' }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ max((int)$daysPast ?? '', 0) }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ max(round($item->penalty ?? $penalty_amount, 2), 0) }}</td>                           
                        <td class="text-center" style="background-color:{{$class}}">{{ $item->discount_amount ?? '' }}</td>
                        <td class="text-center" style="background-color:{{$class}}">{{ $item->total_amount ?? '' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>       
    </div>
    
    {{-- Pay Modal --}}
    <div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentModalLabel">Payment</h5>
                    <button type="button" class="btn-close text-dark" data-bs-dismiss="modal" aria-label="Close">x</button>
                </div>
                <form id="paymentForm" action="{{ route('invoice-emi-store-payment') }}" method="POST">
                    @csrf
                    <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                    <div class="modal-body">                   
                        <div class="table-responsive">
                            <table class="table table-bordered text-xs">
                                <thead>
                                    <tr>
                                        <th class="text-center">EMI Date</th>
                                        <th class="text-center">EMI Amount</th>
                                        <th class="text-center">Paid Date</th>                                   
                                        <th class="text-center">Due Days</th>
                                        <th class="text-center">Penalty Amount</th>
                                        <th class="text-center">Discount Amount</th>
                                        <th class="text-center">Paid Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="paymentDetailsBody">
                                    <!-- Will be populated by JavaScript -->
                                </tbody>  
                                <tfoot>
                                    <tr>
                                        <td colspan="6" class="text-end font-weight-bold">Total Paid Amount:</td>
                                        <td class="text-center">
                                            <input type="text" class="form-control" id="total_paid_amount" name="total_paid_amount" readonly>
                                        </td>
                                    </tr>
                                </tfoot>                                               
                            </table>                      
                        </div>     
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save changes</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>                                   
            </div>
        </div>
    </div>
    
    {{-- Pre-Closure Modal --}}
    <div class="modal fade" id="preClosureModal" tabindex="-1" aria-labelledby="preClosureModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="preClosureModalLabel">Pre-Closure</h5>
                    <button type="button" class="btn-close text-dark" data-bs-dismiss="modal" aria-label="Close">x</button>
                </div>
                <form id="preClosureForm" action="{{ route('invoice-emi-pre-closure') }}" method="POST">
                    @csrf
                    <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                    <div class="modal-body">                                  
                       <div class="row p-3">
                        <div class="col-md-4 mb-3">
                            <label for="remaining_amount">Pre-Closure Amount:</label>
                            <input type="text" class="form-control" id="remaining_amount" name="remaining_amount" value="{{ $pre_closure_amount }}" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="interest_amount">Interest Amount:</label>
                            <input type="text" class="form-control" id="interest_amount" name="interest_amount" value="{{ $invoice->invoice_emi->emi_amount }}" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="paid_date">Paid Date:</label>
                            <input type="date" class="form-control" id="paid_date" name="paid_date" value="{{ date('Y-m-d') }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="discount">Discount Amount:</label>
                            <input type="number" class="form-control" id="discount" name="discount" value="0" min="0" step="0.01">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="penalty">Penalty Amount:</label>
                            <input type="number" class="form-control" id="penalty" name="penalty" value="{{$total_penalty_amount ?? 0}}" min="0" step="0.01">
                        </div> 
                        <div class="col-md-4 mb-3">
                            <label for="total">Total Amount:</label>
                            <input type="text" class="form-control" id="total" name="total" readonly>
                        </div>                   
                        <div class="col-md-4 mb-3">
                            <label for="pay">Pay:</label>
                            <input type="number" class="form-control" id="pay" name="pay" required min="0" step="0.01" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="remarks">Remarks:</label>
                            <input type="text" class="form-control" id="remarks" name="remarks">
                        </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save changes</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>    
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Select all checkboxes (only for enabled items)
    $('#select_all').change(function() {
        $('.select-item:not(:disabled)').prop('checked', $(this).prop('checked'));
    });

    // Payment button click handler
    $('#paymentBtn').click(function() {
        let selectedItems = $('.select-item:checked:not(:disabled)');
        if (selectedItems.length === 0) {
            alert('Please select at least one EMI to pay');
            return false;
        }

        let emiDetails = [];
        selectedItems.each(function() {
            let row = $(this).closest('tr');
            emiDetails.push({
                id: row.data('emi-id'),
                emi_date: row.data('emi-date'),
                emi_amount: parseFloat(row.data('emi-amount')),
                due_days: parseInt(row.data('due-days')),
                penalty: parseFloat(row.data('penalty')),
                discount: parseFloat(row.data('discount')),
                total: parseFloat(row.data('total'))
            });
        });

        // Populate payment modal
        let html = '';
        emiDetails.forEach(function(item) {
            html += `
            <tr>
                <input type="hidden" name="emi_ids[]" value="${item.id}">
                <td class="text-center">${item.emi_date}</td>
                <td class="text-center">${item.emi_amount.toFixed(2)}</td>
                <td class="text-center">
                    <input type="date" class="form-control paid-date" name="paid_dates[${item.id}]" 
                           value="{{ date('Y-m-d') }}" data-emi-id="${item.id}">
                </td>
                <td class="text-center">
                    <input type="number" class="form-control due-days" name="due_days[${item.id}]" 
                           value="${item.due_days}" readonly>
                </td>
                <td class="text-center">
                    <input type="number" class="form-control penalty" name="penalties[${item.id}]" 
                           value="${item.penalty.toFixed(2)}" min="0" step="0.01" data-emi-id="${item.id}">
                </td>
                <td class="text-center">
                    <input type="number" class="form-control discount" name="discounts[${item.id}]" 
                           value="${item.discount.toFixed(2)}" min="0" step="0.01" data-emi-id="${item.id}">
                </td>
                <td class="text-center">
                    <input type="number" class="form-control total" name="totals[${item.id}]" 
                           value="${item.total.toFixed(2)}" readonly>
                </td>
            </tr>
            `;
        });

        $('#paymentDetailsBody').html(html);
        calculateTotalPaidAmount();
    });

    // Handle dynamic field changes in payment modal
    $(document).on('input', '.penalty, .discount', function() {
        let emiId = $(this).data('emi-id');
        let row = $(this).closest('tr');
        calculateEmiTotal(row);
        calculateTotalPaidAmount();
    });

    // Pre-closure modal calculations
    $('#preClosureModal').on('shown.bs.modal', function() {
        calculatePreClosureTotal();
    });

    $('#discount, #penalty').on('input', function() {
        calculatePreClosureTotal();
    });

    // Calculation functions
    function calculateEmiTotal(row) {
        let emiAmount = parseFloat(row.find('td:eq(1)').text()) || 0;
        let penalty = parseFloat(row.find('.penalty').val()) || 0;
        let discount = parseFloat(row.find('.discount').val()) || 0;
        
        let total = emiAmount + penalty - discount;
        row.find('.total').val(total.toFixed(2));
    }

    function calculateTotalPaidAmount() {
        let total = 0;
        $('.total').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#total_paid_amount').val(total.toFixed(2));
    }

    function calculatePreClosureTotal() {
        let remaining = parseFloat($('#remaining_amount').val()) || 0;
        let interest = parseFloat($('#interest_amount').val()) || 0;
        let discount = parseFloat($('#discount').val()) || 0;
        let penalty = parseFloat($('#penalty').val()) || 0;
        
        let total = remaining  + penalty - discount;
        $('#total').val(total.toFixed(2));
        $('#pay').val(total.toFixed(2));
    }
});
</script>
@endpush