@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 px-3">
                            <h4 class="mb-0">Product Purchase Report</h4>
                            <form method="GET" action="{{ route('product-purchase') }}" class="d-flex align-items-center">
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">
                                    @error('start_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">
                                    @error('end_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>
                        <div class="mb-4">
                            <div class="table-responsive">
                                <table class="table text-center text-xs" id="myTable">
                                    <thead>
                                        <tr>
                                            <th>Branch Name</th>
                                            <th>Product Name</th>
                                            <th>Product Code</th>
                                            <th>Purchased Date</th>
                                            <th>Purchase Amount</th>
                                            <th>Paid Amount</th>
                                            <th>Balance Amount</th>
                                            <th>Supplier Name</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($productData as $product)
                                            <tr>
                                                <td>{{$product['branch_name']}}</td>
                                                <td>{{ $product['product_name'] }}</td>
                                                <td>{{ $product['product_code'] }}</td>
                                                <td>{{ \Carbon\Carbon::parse($product['purchase_date'])->format('d-m-Y') }}
                                                </td>
                                                <td>₹ {{ number_format($product['purchase_amount'], 2) }}</td>
                                                <td>₹ {{ number_format($product['paid_amount'], 2) }}</td>
                                                <td>₹ {{ number_format($product['balance_amount'], 2) }}</td>
                                                <td>{{ $product['supplier_name'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection