<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EmoRecord extends Model
{
    protected $fillable = [
        'upload_id',
        'serial_no',
        'product_code',
        'emo_number',
        'emo_amount',
        'emo_message',
        'booking_date',
        'delivered_date',
        'sender_name',
        'sender_mobile',
        'sender_pincode',
        'sender_city',
        'sender_address1',
        'sender_address2',
        'sender_address3',
        'receipt_no',
    ];

    protected $casts = [
        'booking_date'   => 'date',
        'delivered_date' => 'date',
        'emo_amount'     => 'decimal:2',
    ];

    public function upload(): BelongsTo
    {
        return $this->belongsTo(EmoUpload::class, 'upload_id');
    }
}
