<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl leading-tight">
            Upload #{{ $upload->id }} — {{ $upload->original_name }}
        </h2>
    </x-slot>

    <div class="py-8 max-w-6xl mx-auto">
        <div class="mb-4">
            <a href="{{ route('emo.print', $upload) }}" class="px-3 py-2 bg-blue-600 text-white rounded">Print (A3)</a>
            <a href="{{ route('emo.pdf', $upload) }}" class="px-3 py-2 bg-indigo-600 text-white rounded ml-2">Export PDF</a>
        </div>

        <div class="bg-white shadow rounded p-4 overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-100">
                <tr>
                    <th class="p-2 text-left">Receipt #</th>
                    <th class="p-2 text-left">EMO Number</th>
                    <th class="p-2 text-left">Sender</th>
                    <th class="p-2 text-left">Address</th>
                    <th class="p-2 text-left">Amount</th>
                    <th class="p-2 text-left">Booking</th>
                    <th class="p-2 text-left">Acceptance</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                @foreach($records as $r)
                    <tr class="hover:bg-gray-50 transition">
                        <td class="p-2">{{ $r->receipt_no }}</td>
                        <td class="p-2">{{ $r->emo_number }}</td>
                        <td class="p-2">{{ $r->sender_name }}</td>
                        <td class="p-2">{{ $r->sender_address }}</td>
                        <td class="p-2">₹{{ number_format($r->emo_amount,2) }}</td>
                        <td class="p-2">{{ optional($r->booking_date)->format('d/m/Y') }}</td>
                        <td class="p-2">{{ optional($r->acceptance_date)->format('d/m/Y') }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</x-app-layout>
