<?php

use App\Http\Controllers\EmoUploadController;
use Illuminate\Support\Facades\Route;

Route::get('/', fn() => redirect()->route('emo.index'));


Route::middleware('auth')->group(function () {

// Dashboard route with both names
Route::get('/dashboard', [EmoUploadController::class, 'dashboard'])
    ->name('emo.dashboard');

Route::get('/dashboard', [EmoUploadController::class, 'dashboard'])
    ->name('dashboard');

 
    Route::get('/uploads', [EmoUploadController::class, 'index'])->name('emo.index');
    Route::get('/uploads/create', [EmoUploadController::class, 'create'])->name('emo.create');
    Route::post('/uploads', [EmoUploadController::class, 'store'])->name('emo.store');
    Route::get('/uploads/{upload}', [EmoUploadController::class, 'show'])->name('emo.show');

    // actions
    Route::get('/uploads/{upload}/print', [EmoUploadController::class, 'print'])->name('emo.print');
    Route::get('/uploads/{upload}/pdf', [EmoUploadController::class, 'pdf'])->name('emo.pdf');
	
	Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
	
});

require __DIR__.'/auth.php'; // Breeze routes
